% Objective function for deterministic models, full optimum scenario.

function [f] = objective(z,gamma,beta,theta,G1,A1,K1,G2,A2,i2,M2,P1,i2pre,A2pre,P1pre,i)      
    s1(i)=z(1);
    g1(i)=z(2);
    g2(i)=z(3);
    
    C1(i)=((1-s1(i))/(beta*A2))^(1/gamma)*A2/(1-s1(i))*...
               ((1+i2pre)/(1+i2))/((1+theta^(1/gamma))*(1+(1/(beta*A2pre))^(1/gamma)*A2pre))*A1*K1;
    C2(i)=A2/(1-s1(i))*...
               ((1+i2pre)/(1+i2))/((1+theta^(1/gamma))*(1+(1/(beta*A2pre))^(1/gamma)*A2pre))*A1*K1;
    K2(i)=1/((1-g2(i))*(1-s1(i)))*...
               ((1+i2pre)/(1+i2))/((1+theta^(1/gamma))*(1+(1/(beta*A2pre))^(1/gamma)*A2pre))*A1*K1;
    I1(i)=K2(i);
    I2(i)=0;
    G1(i)=g1(i)*A1*K1;
    G2(i)=g2(i)*A2*K2(i);
    Y1AD(i)=C1(i)+I1(i)+G1(i);
    Y1AS(i)= A1*K1;
    Y2AD(i)=C2(i)+I2(i)+G2(i);
    Y2AS(i)=A2*K2(i);
    P1(i)=P1pre;
    P2(i)=M2/C2(i);
    P2check(i)=(1+i2)*1/A2*P1(i);
    M1(i)=P1(i)*C1(i);
    Welfare(i)=1/(1-gamma)*(C1(i)^(1-gamma)+theta*G1(i)^(1-gamma))+...
               beta*1/(1-gamma)*(C2(i)^(1-gamma)+theta*G2(i)^(1-gamma));
f = -Welfare(i);
